#property copyright "InstaForex"
#property link      "http://www.instaforex.com/"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1  Blue
#property indicator_color2  Red
#property indicator_width1  2
#property indicator_width2  2

extern int period = 16;
extern int method = 3; // MODE_SMA
extern int price = 0; // PRICE_CLOSE
extern int shift = 0;

double hmahu[];
double hmahd[];
double hma[];
double trend[];

int init()
{
	IndicatorBuffers(4);
	SetIndexBuffer(0, hmahu);
	SetIndexStyle(0, DRAW_HISTOGRAM);
	SetIndexBuffer(1, hmahd);
	SetIndexStyle(1, DRAW_HISTOGRAM);
	SetIndexBuffer(2, hma);
	SetIndexBuffer(3, trend);

	IndicatorShortName("IFX HMA Histogram(" + period + ")");
	return (0);
}

int deinit()
{
	return (0);
}

int start()
{
	int counted_bars = IndicatorCounted();
	if (counted_bars < 0)
		return (-1);
	if (counted_bars > 0)
		counted_bars--;
	int limit = MathMin(Bars - counted_bars, Bars - 1);
	for (int i = limit; i >= 0; i--)
	{
		hma[i] = iHull(iMA(NULL, 0, 1, 0, method, price, i + shift - 1), period, i);
		hmahu[i] = EMPTY_VALUE;
		hmahd[i] = EMPTY_VALUE;
		trend[i] = trend[i + 1];
		if (hma[i] > hma[i + 1])
			trend[i] = 1;
		if (hma[i] < hma[i + 1])
			trend[i] = -1;
		if (trend[i] == 1)
			hmahu[i] = hma[i];
		if (trend[i] == -1)
			hmahd[i] = hma[i];
	}
	return (0);
}

double workHull[][2];

double iHull(double price, double period, int r, int instanceNo = 0)
{
	if (ArrayRange(workHull, 0) != Bars)
		ArrayResize(workHull, Bars);
	r = Bars - r - 1;

	int HmaPeriod = MathMax(period, 2);
	int HalfPeriod = MathFloor(HmaPeriod / 2);
	int HullPeriod = MathFloor(MathSqrt(HmaPeriod));
	double hma, hmw, weight;
	instanceNo *= 2;

	workHull[r][instanceNo] = price;

	hmw = HalfPeriod;
	hma = hmw * price;
	for (int k = 1; k < HalfPeriod && (r - k) >= 0; k++)
	{
		weight = HalfPeriod - k;
		hmw += weight;
		hma += weight * workHull[r - k][instanceNo];
	}
	workHull[r][instanceNo + 1] = 2.0 * hma / hmw;

	hmw = HmaPeriod;
	hma = hmw * price;
	for (k = 1; k < period && (r - k) >= 0; k++)
	{
		weight = HmaPeriod - k;
		hmw += weight;
		hma += weight * workHull[r - k][instanceNo];
	}
	workHull[r][instanceNo + 1] -= hma / hmw;

	hmw = HullPeriod;
	hma = hmw * workHull[r][instanceNo + 1];
	for (k = 1; k < HullPeriod && (r - k) >= 0; k++)
	{
		weight = HullPeriod - k;
		hmw += weight;
		hma += weight * workHull[r - k][1 + instanceNo];
	}
	return (hma / hmw);
}