#property copyright "InstaForex"
#property link      "http://www.instaforex.com/"
//----
#property indicator_separate_window
#property indicator_minimum 1.0
#property indicator_maximum 4.0
#property indicator_buffers 8
#property indicator_color1  Green
#property indicator_color2  Red
#property indicator_color3  Green
#property indicator_color4  Red
#property indicator_color5  Green
#property indicator_color6  Red
#property indicator_color7  Green
#property indicator_color8  Red
//----
sinput string MA_1 = "Moving Average #1";
//----
input int    Period1     = 13;                // Averaging period.
input ENUM_MA_METHOD    Mode1       = MODE_EMA;          // Averaging method.
input ENUM_APPLIED_PRICE    Price1      = PRICE_MEDIAN;      // The type of the price used for calculaton of Moving Average.
//----
sinput string MA_2 = "Moving Average #2";
//----
input int    Period2     = 34;
input ENUM_MA_METHOD    Mode2       = MODE_EMA;
input ENUM_APPLIED_PRICE    Price2      = PRICE_MEDIAN;
//----
sinput string MA_3 = "Moving Average #3";
//----
input int    Period3     = 55;
input ENUM_MA_METHOD    Mode3       = MODE_EMA;
input ENUM_APPLIED_PRICE    Price3      = PRICE_MEDIAN;
//----
sinput string MA_4 = "Moving Average #4";
//----
input int    Period4     = 89;
input ENUM_MA_METHOD    Mode4       = MODE_EMA;
input ENUM_APPLIED_PRICE    Price4      = PRICE_MEDIAN;
//----

//----

//----
 int    Bar_Wingdings  = 0;
 int    Bar_Width      = 0;
 color  Bar_Color_Up   = Green;
 color  Bar_Color_Down = Red;
//----
 int    P1_Position    = 4;
 int    P2_Position    = 3;
 int    P3_Position    = 2;
 int    P4_Position    = 1;
//----
 double Gap            = 0.6;
//----
 string Set_Label      = "Labels setting";
//----
 bool   Show_Label     = true;
//----
 string V_Label        = "Vertical shift for text labels";
//----
 double V_Shift        = 0.5;
//----
 string H_Label        = "Horizontal shift for text labels";
//----
 int    H_Shift        = 20;
//----
 string UP_DN          = "Moving average direction relative to the price: above/below";
 color  Text_Color_UP    = Green;
 color  Text_Color_Down  = Red;
//+------------------------------------------------------------------+
string Label ="", Short_Name;
//----
double MA1_UP_Buffer[];
double MA1_DN_Buffer[];
double MA2_UP_Buffer[];
double MA2_DN_Buffer[];
double MA3_UP_Buffer[];
double MA3_DN_Buffer[];
double MA4_UP_Buffer[];
double MA4_DN_Buffer[];
//----
double MA0_Buffer_0;
//----
double MA1_Buffer_1;
double MA1_Buffer_0;
double MA2_Buffer_1;
double MA2_Buffer_0;
double MA3_Buffer_1;
double MA3_Buffer_0;
double MA4_Buffer_1;
double MA4_Buffer_0;
//----
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   //----
   int Wingdings_UP, Wingdings_DOWN;
   //----
   if(Bar_Wingdings==0) { Wingdings_UP = 167; Wingdings_DOWN = 167; }
   if(Bar_Wingdings==1) { Wingdings_UP = 217; Wingdings_DOWN = 218; }
   if(Bar_Wingdings!=0 && Bar_Wingdings!=1) { Alert("Please enter the correct value for Bar_Wingdings ! (0-3)"); return; }
   //----
   SetIndexStyle (0, DRAW_ARROW, STYLE_SOLID, Bar_Width, Bar_Color_Up);
   SetIndexArrow (0, Wingdings_UP);
   SetIndexBuffer(0, MA1_UP_Buffer);
   SetIndexEmptyValue(0, 0.0);
   SetIndexStyle (1, DRAW_ARROW, STYLE_SOLID, Bar_Width, Bar_Color_Down);
   SetIndexArrow (1, Wingdings_DOWN);
   SetIndexBuffer(1, MA1_DN_Buffer);
   SetIndexEmptyValue(1, 0.0);
   SetIndexStyle (2, DRAW_ARROW, STYLE_SOLID, Bar_Width, Bar_Color_Up);
   SetIndexArrow (2, Wingdings_UP);
   SetIndexBuffer(2, MA2_UP_Buffer);
   SetIndexEmptyValue(2, 0.0);
   SetIndexStyle (3, DRAW_ARROW, STYLE_SOLID, Bar_Width, Bar_Color_Down);
   SetIndexArrow (3, Wingdings_DOWN);
   SetIndexBuffer(3, MA2_DN_Buffer);
   SetIndexEmptyValue(3, 0.0);
   SetIndexStyle (4, DRAW_ARROW, STYLE_SOLID, Bar_Width, Bar_Color_Up);
   SetIndexArrow (4, Wingdings_UP);
   SetIndexBuffer(4, MA3_UP_Buffer);
   SetIndexEmptyValue(4, 0.0);
   SetIndexStyle (5, DRAW_ARROW, STYLE_SOLID, Bar_Width, Bar_Color_Down);
   SetIndexArrow (5, Wingdings_DOWN);
   SetIndexBuffer(5, MA3_DN_Buffer);
   SetIndexEmptyValue(5, 0.0);
   SetIndexStyle (6, DRAW_ARROW, STYLE_SOLID, Bar_Width, Bar_Color_Up);
   SetIndexArrow (6, Wingdings_UP);
   SetIndexBuffer(6, MA4_UP_Buffer);
   SetIndexEmptyValue(6, 0.0);
   SetIndexStyle (7, DRAW_ARROW, STYLE_SOLID, Bar_Width, Bar_Color_Down);
   SetIndexArrow (7, Wingdings_DOWN);
   SetIndexBuffer(7, MA4_DN_Buffer);
   SetIndexEmptyValue(7, 0.0);
   SetIndexLabel(0, "1_Buffer_UP");
   SetIndexLabel(1, "1_Buffer_DN");
   SetIndexLabel(2, "2_Buffer_UP");
   SetIndexLabel(3, "2_Buffer_DN");
   SetIndexLabel(4, "3_Buffer_UP");
   SetIndexLabel(5, "3_Buffer_DN");
   SetIndexLabel(6, "4_Buffer_UP");
   SetIndexLabel(7, "4_Buffer_DN");
   IndicatorDigits(0);
   Short_Name = "IFX Multi Moving Average";
   IndicatorShortName(Short_Name);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   //----
   int Counted_Bars = IndicatorCounted(), i;
   if(Counted_Bars<0) return(-1);
   if(Counted_Bars>0) Counted_Bars--;
   int Limit = Bars - Counted_Bars;
   if(Counted_Bars==0) Limit--;
   color Text_Color_1, Text_Color_2, Text_Color_3, Text_Color_4;
   //----
   for(i=Limit; i>=0; i--)
     {
      MA0_Buffer_0 = iMA(NULL, 0, 1, 0, MODE_SMA, PRICE_MEDIAN, i);
      //----
      MA1_Buffer_0 = iMA(NULL, 0, Period1, 0, Mode1, Price1, i);
      MA1_Buffer_1 = iMA(NULL, 0, Period1, 0, Mode1, Price1, i+1);
      MA2_Buffer_0 = iMA(NULL, 0, Period2, 0, Mode2, Price2, i);
      MA2_Buffer_1 = iMA(NULL, 0, Period2, 0, Mode2, Price2, i+1);
      MA3_Buffer_0 = iMA(NULL, 0, Period3, 0, Mode3, Price3, i);
      MA3_Buffer_1 = iMA(NULL, 0, Period3, 0, Mode3, Price3, i+1);
      MA4_Buffer_0 = iMA(NULL, 0, Period4, 0, Mode4, Price4, i);
      MA4_Buffer_1 = iMA(NULL, 0, Period4, 0, Mode4, Price4, i+1);
      
      MA1_UP_Buffer[i] = EMPTY_VALUE;
      MA1_DN_Buffer[i] = EMPTY_VALUE;
      
      if(MA1_Buffer_0 < MA1_Buffer_1) MA1_DN_Buffer[i] = Gap * P1_Position + 1.0;
      else                            MA1_UP_Buffer[i] = Gap * P1_Position + 1.0;
      if(MA1_Buffer_0 < MA0_Buffer_0) Text_Color_1 = Text_Color_UP;
      else                            Text_Color_1 = Text_Color_Down;
      //----
      MA2_UP_Buffer[i] = EMPTY_VALUE;
      MA2_DN_Buffer[i] = EMPTY_VALUE;
      
      if(MA2_Buffer_0 < MA2_Buffer_1) MA2_DN_Buffer[i] = Gap * P2_Position + 1.0;
      else                            MA2_UP_Buffer[i] = Gap * P2_Position + 1.0;
      if(MA2_Buffer_0 < MA0_Buffer_0) Text_Color_2 = Text_Color_UP;
      else                            Text_Color_2 = Text_Color_Down;
      //----
      MA3_UP_Buffer[i] = EMPTY_VALUE;
      MA3_DN_Buffer[i] = EMPTY_VALUE;
      
      if(MA3_Buffer_0 < MA3_Buffer_1) MA3_DN_Buffer[i] = Gap * P3_Position + 1.0;
      else                            MA3_UP_Buffer[i] = Gap * P3_Position + 1.0;
      if(MA3_Buffer_0 < MA0_Buffer_0) Text_Color_3 = Text_Color_UP;
      else                            Text_Color_3 = Text_Color_Down;
      //----
      MA4_UP_Buffer[i] = EMPTY_VALUE;
      MA4_DN_Buffer[i] = EMPTY_VALUE;
      
      if(MA4_Buffer_0 < MA4_Buffer_1) MA4_DN_Buffer[i] = Gap * P4_Position + 1.0;
      else                            MA4_UP_Buffer[i] = Gap * P4_Position + 1.0;
      if(MA4_Buffer_0 < MA0_Buffer_0) Text_Color_4 = Text_Color_UP;
      else                            Text_Color_4 = Text_Color_Down;
      //----
      //----
      LabelSet(Text_Color_1, Text_Color_2, Text_Color_3, Text_Color_4);
      //----
     }   
//----
   return(0);
  }
//+------------------------------------------------------------------+
int LabelSet(color Text_Color_1, color Text_Color_2, color Text_Color_3, color Text_Color_4)
  {
   //----
   int i;
   double Price, ID =Time[0] - Time[1];
   string Name, Text;
   color Text_Color;
   //----
   if(Show_Label==TRUE)
     {
      for(i=1; i<=4; i++)
        {
         switch(i)
           {
            case 1: Text       = Time_Frame() + " " + Mode(Mode1) + " " + "(" + Period1 + ")";
                    Price      = Gap * P1_Position + 1.0 + V_Shift;
                    Text_Color = Text_Color_1;
                    break;
            case 2: Text       = Time_Frame() + " " + Mode(Mode2) + " " + "(" + Period2 + ")";
                    Price      = Gap * P2_Position + 1.0 + V_Shift;
                    Text_Color = Text_Color_2;
                    break;
            case 3: Text       = Time_Frame() + " " + Mode(Mode3) + " " + "(" + Period3 + ")";
                    Price      = Gap * P3_Position + 1.0 + V_Shift;
                    Text_Color = Text_Color_3;
                    break;
            case 4: Text       = Time_Frame() + " " + Mode(Mode4) + " " + "(" + Period4 + ")";
                    Price      = Gap * P4_Position + 1.0 + V_Shift;
                    Text_Color = Text_Color_4;
           }
           
         Name = WindowFind(Short_Name);
         ObjectDelete (Name + i);
         ObjectCreate (Name + i, OBJ_TEXT, WindowFind(Short_Name), iTime(NULL, 0, 0) + ID * H_Shift, Price);
         ObjectSetText(Name + i, Text, 8, "Arial Bold", Text_Color);
        }
     }
   return(0);
  }       
//----
string Time_Frame()
  {
   if (Period() == PERIOD_M1 ) return ("M1");
   if (Period() == PERIOD_M5 ) return ("M5");
   if (Period() == PERIOD_M15) return ("M15");
   if (Period() == PERIOD_M30) return ("M30");
   if (Period() == PERIOD_H1 ) return ("H1");
   if (Period() == PERIOD_H4 ) return ("H4");
   if (Period() == PERIOD_D1 ) return ("D1");
   if (Period() == PERIOD_W1 ) return ("W1");
   if (Period() == PERIOD_MN1) return ("MN");
  }
//----
string Mode(int MA_Mode)
  {
   switch(MA_Mode)
     {
      case 0 : return("SMA");
               break;
     
      case 1 : return("EMA");
               break;
               
      case 2 : return("SSMA");
               break;
               
      case 3 : return("LWMA");
     }
  }
//+------------------------------------------------------------------+